DROP PROCEDURE [hips].[PostalDeliveryTypeCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the PostalDeliveryType Code Table
-- =============================================
CREATE PROCEDURE [hips].[PostalDeliveryTypeCodeGet] 
(
	@CodeSystemCode VARCHAR(20),
	@PostalDeliveryTypeId INT = NULL
)
AS
BEGIN

	SELECT  pdt.PostalDeliveryTypeId, pdt.Code, pdt.Description
	FROM    hips.PostalDeliveryTypeCode pdtc
			JOIN hips.PostalDeliveryType pdt ON pdtc.PostalDeliveryTypeId = pdt.PostalDeliveryTypeId
			JOIN hips.CodeSystem cs ON pdtc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND (pdt.PostalDeliveryTypeId = @PostalDeliveryTypeId OR @PostalDeliveryTypeId IS NULL)
	ORDER BY pdt.Description

END
GO

